function r2 = r2cum(x,y)

%r2 = r2cum(x,y)
%
%returns the column vector r2, which contains 
%cumulative r squared values
%
%The first value is NaN, the second value is 1.0
%
%This is useful for finding the straight part of a function
%
%Spring 2001, Christopher Brown, cbrown@phi.luc.edu

if nargin==1

	if size(x,2) == 2		%1 variable, 2-column
		xtemp = x';
	else
		xtemp = x;
	end
		clear x;
		x = xtemp(1,:);
		y = xtemp(2,:);
		clear xtemp;

elseif nargin==2

	if size(x,2) == 1
		x = x.';
	end
	if size(y,2) == 1
		y = y.';
	end
end

if length(x)>length(y)
	y = y(1:length(x));
   warning('Lengths of vectors are mismatched. Truncating y.');
elseif length(x)<length(y)
	x = x(1:length(y));
   warning('Lengths of vectors are mismatched. Truncating x.');
end

last = length(x);

sampsize = 1:last;
Exy2 = (cumsum(x.*y) - ((cumsum(x).*cumsum(y))./sampsize)).^2;
Ex2 = cumsum(x.^2) - (((cumsum(x)).^2)./sampsize);
totss = cumsum(y.^2) - (((cumsum(y)).^2)./sampsize);
regss = Exy2(2:last)./Ex2(2:last);
r2(1) = NaN;
r2(2:last) = regss ./ totss(2:last);
r2 = r2.';
